#!/bin/sh

# Note that if you change the ORACLE_HOME or ORACLE_BASE in the response files
# then you will also need to update this script

echo 'INSTALLER: Starting up'
# set variables
ORACLE_USER="oracle"
DBA_GROUP="dba"
SID="orcl"
ORACLE_ROOT="/u01"
PASSWORD="AI"
ORACLE_BASE="$ORACLE_ROOT/app/$ORACLE_USER"
ORACLE_HOME="$ORACLE_BASE/product/11.2.0/dbhome_1" 
DATA_LOCATION="$ORACLE_BASE/oradata"
INVENTORY_LOCATION="$ORACLE_ROOT/app/oraInventory"

# add a new swapfile of 3G and attach it
# total swap approx 4G
dd if=/dev/zero of=/swapfile bs=1024 count=3072000
chmod 600 /swapfile
mkswap /swapfile
swapon /swapfile
echo "/swapfile swap swap defaults 0 0" >> /etc/fstab

echo 'INSTALLER: Expanded swap'

# convert into Oracle Linux 7
#curl -O https://linux.oracle.com/switch/centos2ol.sh
#sh centos2ol.sh
#rm /home/vagrant/centos2ol
#
#echo 'INSTALLER: Now running Oracle Linux 6'
#
# install required libraries
#yum install -y nano
#yum install -y libaio
#yum install -y libaio-devel
#yum install -y kernel-headers
#yum install -y kernel-devel
#yum install zip unzip -y
#
# get up to date
#yum upgrade -y
#yum update -y
#
#echo 'INSTALLER: System updated'
#
# fix locale warning
#yum reinstall -y glibc-common
#echo LANG=en_US.utf-8 >> /etc/environment
#echo LC_ALL=en_US.utf-8 >> /etc/environment

echo 'INSTALLER: Locale set'

# install Oracle Database prereq packages
#mgj yum install -y oracle-rdbms-server-12cR1-preinstall
yum install -y oracle-rdbms-server-11gR2-preinstall

echo 'INSTALLER: Oracle preinstall complete'

# create directories
if [ ! -d "/u01" ]; then
	mkdir /u01
fi

if [ ! -d "/u01/app" ]; then
	mkdir /u01/app
fi

if [ ! -d "/u01/app/oracle" ]; then
	mkdir /u01/app/oracle
fi

if [ ! -d "/u01/app/oraInventory" ]; then
	mkdir /u01/app/oraInventory
fi

if [ ! -d "/u01/tmp" ]; then
	mkdir /u01/tmp
fi

chown oracle:oinstall -R /u01

echo 'INSTALLER: Oracle directories created'

# set environment variables
echo "export ORACLE_BASE=/u01/app/oracle" >> /home/oracle/.bashrc \
 && echo "export ORACLE_HOME=/u01/app/oracle/product/11.2.0/dbhome_1" >> /home/oracle/.bashrc \
 && echo "export ORACLE_SID=orcl" >> /home/oracle/.bashrc \
 && echo "export PATH=\$PATH:\$ORACLE_HOME/bin" >> /home/oracle/.bashrc


echo 'INSTALLER: Environment variables set'

# install Oracle

echo 'INSTALLER: Unzip Oracle installer...'

/bin/unzip -q /installs/linux.x64_11gR2_database_1of2.zip -d /u01/tmp
/bin/unzip -q /installs/linux.x64_11gR2_database_2of2.zip -d /u01/tmp

#su -l oracle -c "yes | /vagrant/database/runInstaller -silent -showProgress -ignorePrereq -waitforcompletion -responseFile $ORACLE_ROOT/tmp/db_install_my.rsp"
su -l oracle -c "yes | /u01/tmp/database/runInstaller -silent -waitforcompletion -ignorePrereq -responseFile /vagrant/oracle/templates/db_install_my.rsp"
/u01/app/oraInventory/orainstRoot.sh
/u01/app/oracle/product/11.2.0/dbhome_1/root.sh

echo 'INSTALLER: Oracle installed'

### this bug is specific to 12c...we are running 11g so I commented it out - mgj
# To workaround an installer bug, we need to ensure a missing library is in place, then rebuild and relink
# The actual Oracle installation appears to work, however the logs show this:
# INFO: /usr/bin/ld: cannot find -ljavavm12
# Which then causes a compilation failure and the oracle binary (and several others) end up being 0 bytes
# Ref: http://ruleoftech.com/2016/problems-with-installing-oracle-db-12c-ee-ora-12547-tns-lost-contact
# Optionally:
# make -kf ins_reports60w.mk install (on CCMgr server)
# make -kf ins_forms60w.install (on Forms/Web server)
# And then to fix the error on relinking, reinstall Perl:
# Ref: https://dbasolved.com/2015/08/24/issue-with-perl-in-oracle_home-during-installs/

##ORACLE_HOME=/u01/app/oracle/product/11.2.0/dbhome_1

# Reinstall Perl
##wget http://www.cpan.org/src/5.0/perl-5.14.4.tar.gz -P /tmp/
##tar -xzf /tmp/perl-5.14.4.tar.gz -C /tmp/
##cd /tmp/perl-5.14.4
##./Configure -des -Dprefix=$ORACLE_HOME/perl
##make
##make install
##chown oracle:oinstall $ORACLE_HOME/perl

# Recompile and relink
##su -l oracle -c "mv $ORACLE_HOME/rdbms/lib/config.o $ORACLE_HOME/rdbms/lib/config.o.bad"
##su -l oracle -c "cp $ORACLE_HOME/javavm/jdk/jdk6/lib/libjavavm12.a $ORACLE_HOME/lib/"
##su -l oracle -c "chown oracle:oinstall $ORACLE_HOME/lib/libjavavm12.a"
##su -l oracle -c "make -f $ORACLE_HOME/rdbms/lib/ins_rdbms.mk install"
##su -l oracle -c "make -f $ORACLE_HOME/network/lib/ins_net_server.mk install"
##su -l oracle -c "make -kf $ORACLE_HOME/sqlplus/lib/ins_sqlplus.mk install"
##su -l oracle -c "$ORACLE_HOME/bin/relink all"

##echo 'INSTALLER: Oracle installation fixed and relinked'

# create listener via netca
su -l oracle -c "netca -silent -responseFile /vagrant/oracle/templates/netca.rsp"
echo 'INSTALLER: Listener created'

# create database
su -l oracle -c "dbca -silent -createDatabase -responseFile /vagrant/oracle/templates/dbca.rsp"
echo 'INSTALLER: Database created'

sed '$s/N/Y/' /etc/oratab | sudo tee /etc/oratab > /dev/null
echo 'INSTALLER: Oratab configured'

# configure systemd to start oracle instance on startup
sudo cp /vagrant/scripts/oracle-rdbms.service /etc/systemd/system/
sudo systemctl daemon-reload
sudo systemctl enable oracle-rdbms
sudo systemctl start oracle-rdbms
echo "INSTALLER: Created and enabled oracle-rdbms systemd's service"

# remove Oracle installer directory
/bin/rm -rf /u01/tmp
echo "INSTALLER: Installer directory removed"

echo 'INSTALLER: Installation complete'
